//MENU MIDIA
document.addEventListener("DOMContentLoaded", function () {

    const close = document.getElementById("close");
    const bar = document.getElementById("bar");
    const nav = document.getElementById("navbar");
  
    if (bar && nav) {
        bar.addEventListener("click", () => {
            nav.classList.add("active");
        });
    }
  
    if (close) {
        close.addEventListener("click", () => {
            nav.classList.remove("active");
        });
    }
  
    // Fecha o menu ao clicar fora dele
    document.addEventListener("click", (event) => {
        if (nav && bar && !nav.contains(event.target) && !bar.contains(event.target)) {
            nav.classList.remove("active");
        }
    });
}); 


document.addEventListener("DOMContentLoaded", function () {
    // Rolagem suave para âncoras do menu
    document.querySelectorAll('#navbar a[href^="#"]').forEach(link => {
      link.addEventListener("click", function (e) {
        e.preventDefault();
        const destino = document.querySelector(this.getAttribute("href"));
        if (destino) {
          destino.scrollIntoView({
            behavior: "smooth"
          });
        }
  
        // Fecha o menu no mobile após clique
        document.getElementById("navbar").classList.remove("active");
      });
    });
  });

//VIRAR O CARROSEL
document.addEventListener("DOMContentLoaded", function () {
    const toggleBtn = document.getElementById("toggleView");
    const carousel = document.querySelector(".carousel");
  
    if (toggleBtn && carousel) {
      toggleBtn.addEventListener("click", () => {
        if (window.innerWidth <= 768) {
          const isVertical = carousel.classList.toggle("vertical");
  
          toggleBtn.innerHTML = isVertical
            ? '<i class="fas fa-sliders-h"></i>'
            : '<i class="fas fa-list"></i>';
        }
      });
    }
  });

  
//Pop up no carrosel 

document.addEventListener("DOMContentLoaded", function () {
  const popup = document.getElementById("produto-popup");
  const closeBtn = document.querySelector(".close-popup");
  const itensCarrossel = document.querySelectorAll(".carousel-item");

  // Abrir popup ao clicar em qualquer produto
  itensCarrossel.forEach(item => {
    item.addEventListener("click", () => {
      const nome = item.querySelector("h4")?.innerText || "Produto";
      const descricao = item.querySelector("p")?.innerText || "";

      // Atualiza conteúdo visível do popup
      document.getElementById("produto-nome").innerText = nome;
      document.getElementById("produto-descricao").innerText = descricao;

      // Preenche campos escondidos do formulário
      document.getElementById("input-produto-nome").value = nome;
      document.getElementById("input-produto-descricao").value = descricao;

      popup.style.display = "flex";
    }); 
  });

  // Fechar popup
  closeBtn.addEventListener("click", () => {
    popup.style.display = "none";
  });

  // Fechar ao clicar fora da caixa
  window.addEventListener("click", (e) => {
    if (e.target === popup) {
      popup.style.display = "none";
    }
  });

  // (opcional) Alerta visual
  const form = document.querySelector(".popup-form");
  form.addEventListener("submit", function (e) {
    // Remova essa parte se estiver usando PHP com redirecionamento
    // e deixe o form enviar normalmente com action="popup_send.php"
  });
});

  // VER MAIS INFOMAÇOES

  const btnVerMais = document.getElementById("btn-ver-mais");
const btnMenos = document.getElementById("btn-menos");
const detalhesDiv = document.getElementById("produto-detalhes");
const tabela = document.getElementById("tabela-detalhes-conteudo");

const dadosPorModelo = {
"Zebra ZT410": [
    ["Acompanha software", "Sim"],
    ["Conexão", "USB / Ethernet / Bluetooth"],
    ["Tamanho máximo do ribbon", "450 metros"],
    ["Resolução de impressão", "203 DPI"],
    ["Método de impressão", "Transferência térmica / Térmica direta"],
    ["Velocidade de impressão", "356mm/s"],
    ["Largura de impressão", "Até 104mm"],
    ["Comprimento de impressão", "Até 3998mm"],
    ["Voltagem", "Bivolt"],
    ["Peso", "16.3 Kg"]
  ],
"Argox OS-214 Plus": [
    ["Velocidade Excepcional de Impressão", "Até 76 mm por segundo"],
    ["Opções de Impressão", "Transferência térmica e térmica direta"],
    ["Conectividade", "USB, Paralela e Serial RS232"],
    ["Manutenção", "Apenas dez parafusos para todo o equipamento"],
    ["Adaptação para Quiosques", "Tampa superior facilmente destacável"],
    ["Códigos de Barras", "Suporta 1D/GS, 2D/Composite e QR Codes"]
  ],
"Elgin L42 Pro": [
  ["Linguagens de Impressão", "EPL / ZPL / PPLA / PPLB (reconhecimento automático)"],
  ["Interfaces de Comunicação", "USB (incluso) + 1 opcional: Ethernet, RS-232 ou Paralela"],
  ["Vida útil da cabeça térmica", "Não especificado"],
  ["Corte do papel", "Não especificado"],
  ["Etiquetas para balanças Elgin DP", "Compatível"],
  ["Resolução", "203dpi / 300dpi (opcional instalável em campo)"],
  ["Softwares gratuitos", "Bartender Ultra Lite e Direct Print"],
  ["Método de Impressão", "Transferência térmica / Térmica direta"],
  ["Dimensões", "198(L) x 171(A) x 240(P) mm"],
  ["Alimentação", "Entrada 110/220Vac, Saída 24Vdc 2A"],
  ["Velocidade de Impressão", "Máx. 4 pol./seg."],
  ["Ribbon", "110mm x 100m máx. (cera/misto/resina)"],
  ["Largura de Impressão", "Máx. 108mm"],
  ["Vida útil da guilhotina", "Não especificado"],
  ["Tipos de Etiqueta", "Vários tamanhos e materiais"],
  ["Diferenciais", "Alta conectividade, diversidade de materiais"],
  ["Software incluso", "Software para criação de etiquetas incluso"],
  ["Garantia", "18 meses na impressora / 12 meses na cabeça de impressão"],
  ["Origem", "Fabricação Nacional"]
],

"Zebra ZD230": [
  ["Resolução", "203 dpi / 8 pontos por mm"],
  ["Memória", "256 MB de Flash e 128 MB de SDRAM"],
  ["Largura máxima de impressão", "4,09 pol. / 104 mm para 203 dpi"],
  ["Velocidade máxima de impressão", "6 pol. / 152 mm por segundo"],
  ["Sensores de mídia", "Sensor de marca preta móvel (centro → esquerda), sensor de falha excêntrico fixo"],
  ["Firmware", "ZPL II, EPL 2, XML"]
],
"Zebra ZT230": [
  ["Acompanha software", "Sim"],
  ["Conexão", "Serial / USB"],
  ["Tamanho máximo do ribbon", "450 metros"],
  ["Resolução de impressão", "203 DPI"],
  ["Método de impressão", "Transferência térmica / Térmica direta"],
  ["Velocidade de impressão", "152mm/s"],
  ["Largura de impressão", "Até 104mm"],
  ["Comprimento de impressão", "Até 3998mm"],
  ["Voltagem", "Bivolt"],
  ["Peso", "9.1 Kg"]
],


};

btnVerMais.addEventListener("click", () => {
  const nome = document.getElementById("produto-nome").innerText;
  const dados = dadosPorModelo[nome];
  if (!dados) {
    tabela.innerHTML = `<tr><td colspan="2">Informações técnicas não disponíveis.</td></tr>`;
  } else {
    tabela.innerHTML = dados.map(item => `<tr><td>${item[0]}</td><td>${item[1]}</td></tr>`).join("");
  }

  detalhesDiv.style.display = "block";
  btnVerMais.style.display = "none";
  btnMenos.style.display = "inline-block";
});

btnMenos.addEventListener("click", () => {
  detalhesDiv.style.display = "none";
  btnVerMais.style.display = "inline-block";
  btnMenos.style.display = "none";
});

//        ENVIA O FORMULARIO DO PRIMEIRO FORMULARIO 
document.getElementById('contact-form').addEventListener('submit', async function(e) {
  e.preventDefault(); // Impede o envio normal que redirecionaria

  const formData = new FormData(this);

  const data = {};
  formData.forEach((value, key) => (data[key] = value));

  console.log('Dados do formulário:', data); // Verifique os dados

  try {
    const response = await fetch('https://webh.fardigital.com.br/webhook/send_email', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(data)
    });

    console.log('Resposta do servidor:', response); // Verifique a resposta do servidor

    if (response.ok) {
      alert('Formulário enviado com sucesso!');
    } else {
      // Tente obter o corpo da resposta em caso de erro
      const errorData = await response.json();
      console.error('Erro da resposta:', errorData);
      alert('Erro ao enviar o formulário.');
    }
  } catch (error) {
    console.error('Erro no envio:', error);
    alert('Erro ao enviar o formulário.');
  }
});


// Envio via fetch do formulário do popup
const form = document.querySelector(".popup-form");
form.addEventListener("submit", async function (e) {
  e.preventDefault();

  const formData = new FormData(this);
  const data = {};
  formData.forEach((value, key) => (data[key] = value));

  console.log("Enviando dados do popup:", data);

  try {
    const response = await fetch('https://webh.fardigital.com.br/webhook/impressora_popup', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(data)
    });

    if (response.ok) {
      alert("Solicitação enviada com sucesso!");
      form.reset();
      document.getElementById("produto-popup").style.display = "none";
    } else {
      const err = await response.text();
      console.error("Erro:", err);
      alert("Erro ao enviar solicitação.");
    }
  } catch (err) {
    console.error("Erro no envio:", err);
    alert("Erro ao enviar.");
  }
});

console.log("oi")